close all;     clear all;     clc;

figure(1);
colorIndex = 1;
colors = ['r', 'g', 'b', 'y', 'c', 'm', 'k'];
for ii = 5:7,

   %% Load the data
   eval(['load ./' num2str(ii) '_Pattern/PatternSolverData.mat']);

   %% Get the MTF values
   mtf50 = zeros(length(savedData),1);
   avgDeltaE  = zeros(length(savedData),1);
   noise = zeros(length(savedData),1);
   for ii = 1:length(savedData),
      mtf50(ii) = savedData(ii).mtf50;
      avgDeltaE(ii) = savedData(ii).avgDeltaE;
      noise(ii) = savedData(ii).noise;
   end

   %% Find the noise delta
   minNoise = min(noise);
   maxNoise = max(noise);
   deltaNoise = maxNoise - minNoise;
   disp(['Noise Delta = ' num2str(deltaNoise)]);

   %% Plot the delta E vs mtf50
   %scatter(mtf50, avgDeltaE, 75, noise, 'filled');
   %h = colorbar;
   %set(h, 'YTick', [min(noise) max(noise)]); 
   %set(h, 'YTickLabel', {'Low Noise', 'High Noise'});
   plot(mtf50, avgDeltaE, [colors(colorIndex) '.'], 'MarkerEdgeColor',colors(colorIndex),...
        'MarkerFaceColor',colors(colorIndex),...
        'MarkerSize',10)
   hold on;
   
   colorIndex = colorIndex+1;
end
legend('5-Color', '6-Color', '7-Color');
grid on;
xlabel('MTF-50');
ylabel('Average \Delta E');
title('Uniform Filter Spacing, Pattern Varying');
saveas(gcf, './PatternVarying.eps', 'epsc2');


%% Find the patterns associated with the best value

for numFilters = 5:7,

   %% Load the data
   eval(['load ./' num2str(numFilters) '_Pattern/PatternSolverData.mat']);
   
   %% Get the MTF values
   mtf50 = zeros(length(savedData),1);
   for ii = 1:length(savedData),
      mtf50(ii) = savedData(ii).mtf50;
   end
   
   maxMTF = max(mtf50);
   
   maxIndeces = find(mtf50 == maxMTF);
   bestPatterns = savedData(maxIndeces).pattern;
   %bestPatterns

   % Create an array of colors to represent the best pattern
   for patternIndex = size(bestPatterns, 3),

      p = bestPatterns(:,:, patternIndex);

      sensorColorArray = zeros([size(p),3]);
      for ii = 1:size(p,1),
         for jj = 1:size(p,2),
            [r,g,b] = WavelengthToRGB(cPos(p(ii,jj)));
            sensorColorArray(ii,jj,1) = r;
            sensorColorArray(ii,jj,2) = g;
            sensorColorArray(ii,jj,3) = b;
         end
      end
      figure();
      sensorColorArray = imresize(sensorColorArray, [60,60], 'nearest');
      imagesc(sensorColorArray, [0,1]);
      axis image
      title(['Pattern for ' num2str(numFilters) ' colors']);
      for ii = 1:size(p,1),
         for jj = 1:size(p,2),
            %text(-pi/4,sin(-pi/4),'\leftarrow sin(-\pi\div4)',...
            %'HorizontalAlignment','left')
            
            ypos = 20*ii - 10;
            xpos = 20*jj - 10;
            text(xpos, ypos, [num2str(cPos(p(ii,jj))) ' nm'], 'HorizontalAlignment', 'center');
         end
      end
      
      saveas(gcf, ['./' num2str(numFilters) '_Color.eps'], 'epsc2');
      
      disp(['The best pattern for ' num2str(numFilters) ' colors is:']);
      p
      
   end
end

% End of File
